﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.Runtime.InteropServices;
using interop.ICApiIronCAD;

namespace ICApiAddin.MyFirstAddin
{
    [ComVisible(false)]
    public partial class ICToolsForm : Form
    {
        private IZDoc m_iZDoc;

        public ICToolsForm()
        {
            InitializeComponent();
        }

        public IZDoc IronCADDocument
        {
            set { m_iZDoc = value; }
        }

        private void ICToolsForm_Load(object sender, EventArgs e)
        {
            if (m_iZDoc != null)
            {
                lblDisplay.Text = m_iZDoc.Name;
                lblResult.Text = GetDocInfo();
            }
            else
            {
                lblDisplay.Text = "No Document";
            }
        }

        private void btnExit_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private string GetDocInfo()
        {
            string msg = string.Empty;
            if (m_iZDoc != null)
            {
                IZSceneDoc iZsceneDoc = m_iZDoc as IZSceneDoc;
                if (iZsceneDoc != null)
                {
                    msg += "It is a scene document" + Environment.NewLine;
                    IZSelectionMgr iZselectionMgr = iZsceneDoc.SelectionMgr;
                    if (iZselectionMgr != null)
                    {
                        object elements = iZselectionMgr.GetSelectedElements();
                        List<IZElement> list = Addin.ConvertObjectToElementArray(elements);
                        if (list != null && list.Count > 0)
                        {
                            msg += "Selected Elements:" + Environment.NewLine;
                            foreach (IZElement izEle in list)
                            {
                                string eleDesc = izEle.Type.ToString() + ": " + izEle.Name;
                                IZSceneElement izSceneEle = izEle as IZSceneElement;
                                if (izSceneEle != null)
                                {
                                    eleDesc += ", it is a scene element";
                                    izSceneEle.Unlink();
                                }
                                else
                                {
                                }
                                msg += eleDesc + Environment.NewLine;
                            }
                        }
                        else
                        {
                            msg += "This nothing selected" + Environment.NewLine;
                        }
                    }
                    else
                    {
                        msg += "Could not get selection manager" + Environment.NewLine;
                    }
                }
                else
                {
                    IZDrawingDoc iZDrawingDoc = m_iZDoc as IZDrawingDoc;
                    if (iZDrawingDoc != null)
                    {
                        msg += "It is a drawing document" + Environment.NewLine;
                    }
                }
            }
            return msg;
        }
    }
}
