﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.Runtime.InteropServices;
using System.Windows.Forms;
using interop.ICApiIronCAD;

namespace ICApiAddin.MyFirstAddin
{
    [Guid("6AE87CEF-C966-4938-A945-50D4280F60D0"), ClassInterface(ClassInterfaceType.None), ProgId("MyFirstAddin.AddIn")]
    public class Addin : IZAddinServer
    {
        #region [Private Members]
        private ZAddinSite m_izAddinSite;
        private ZCommandHandler m_button;
        #endregion

        //Constractor
        public Addin()
        {
        }

        #region [Public Properties]
        public IZBaseApp IronCADApp
        {
            get
            {
                if (m_izAddinSite != null)
                    return m_izAddinSite.Application;
                return null;
            }

        }

        #endregion

        #region [IZAddinServer Members]
        public void InitSelf(ZAddinSite piAddinSite)
        {
            if (piAddinSite != null)
            {
                m_izAddinSite = piAddinSite;
                try
                {
                    //Create button handler
                    stdole.IPictureDisp oImageSmall = ConvertImage.ImageToPictureDisp(Properties.Resources.c1_small);
                    stdole.IPictureDisp oImageLarge = ConvertImage.ImageToPictureDisp(Properties.Resources.c1_large);
                    m_button = piAddinSite.CreateCommandHandler("FirstAddin", "FirstAddin", "First Addin", "First Addin", oImageSmall, oImageLarge);
                    m_button.Enabled = true;

                    //Control bar
                    ZControlBar cControlBar;
                    ZEnvironmentMgr cEnvMgr = this.IronCADApp.EnvironmentMgr;
                    ZControls cControls;
                    IZControl cControl;
                    ZRibbonBar cRibbonBar;

                    //Setup toolbar for scene
                    IZEnvironment cEnv = cEnvMgr.get_Environment(eZEnvType.Z_ENV_SCENE);
                    cRibbonBar = cEnv.GetRibbonBar(eZRibbonBarType.Z_RIBBONBAR);
                    cControlBar = cEnv.AddControlBar(piAddinSite, "First Addin");
                    cControls = cControlBar.Controls;
                    cControl = cControls.Add(ezControlType.Z_CONTROL_BUTTON, m_button.ControlDescriptor, null);

                    //Add button to RibbonBar
                    cRibbonBar.AddButton(m_button.ControlDescriptor);

                    //Event handlers
                    m_button.OnClick += new _IZCommandEvents_OnClickEventHandler(m_button_OnClick);
                    m_button.OnUpdate += new _IZCommandEvents_OnUpdateEventHandler(m_button_OnUpdate);

                    //Register App Events
                }
                catch (Exception ex)
                {
                    MessageBox.Show("Error: " + ex.Message);
                }
            }
            else
            {
                MessageBox.Show("Addin Server is null.");
            }
        }


        public void DeInitSelf()
        {
            m_button = null;
         }

        #endregion

        #region [Private Methods]
        private void m_button_OnUpdate()
        {
            m_button.Enabled = true;  //Change to m_button.Enabled = false; to disable the button  
        }

        private void m_button_OnClick()
        {
            IZDoc iZDoc = GetActiveDoc();
            if (iZDoc != null)
            {
                ICToolsForm frm = new ICToolsForm();
                frm.IronCADDocument = iZDoc;
                frm.Show();
            }
        }

        private IZDoc GetActiveDoc()
        {
            if (this.IronCADApp != null)
            {
                return this.IronCADApp.ActiveDoc;
            }
            return null;
        }


        #endregion

        #region [Internal Methods]

        internal static List<IZElement> ConvertObjectToElementArray(object varElements)
        {
            if (varElements != null)
            {
                object[] oElements = varElements as object[];
                if (oElements != null)
                {
                    List<IZElement> izElements = new List<IZElement>();
                    foreach(object oEle in oElements)
                    {
                        IZElement izEle = oEle as IZElement;
                        if (izEle != null)
                        {
                            izElements.Add(izEle);
                        }
                    }
                    return izElements;
                }
            }
            return null;
        }

        #endregion
    }
}
